 /*******************************************************************
 *
 *  DESCRIPTION: Atomic Model Base Station Queue
 *
 *  AUTHOR: Misagh Tavanpour
 *
 *  DATE: 25/10/2012
 *
 *******************************************************************/

 #ifndef __BSQUEUE_H
 #define __BSQUEUE_H

 #include "atomic.h"     // class Atomic
 #include "string.h"	 // class String
 #include "list.h"

 class BSQueue : public Atomic
 {
   public:
	       BSQueue( const std::string &name = "BSQueue" );	//Default constructor
	       virtual std::string className() const { return "BSQueue"; }
	       ~BSQueue();

   protected:
	          Model &initFunction();
	          Model &externalFunction( const ExternalMessage & );
	          Model &internalFunction( const InternalMessage & );
	          Model &outputFunction( const InternalMessage & );

   private:
	        const Port &IB1,&IB2,&IB3,&IB4,&IB5,&IB6,&IU0,&Req;
	        Port &Out;
	        Time ProcessTime;
	        typedef list<Value> ElementList ;
	        ElementList elements;
	        int Request;
	        int Qlen;
         	enum State{
			            Idle,       //initial state
			            Push,
			            Pop,
		              };
		    State state;
 };	// class BSQueue

 #endif   //__BSQUEUE_H
